// SimpleGCode.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"
#include "GCodeInterpreter.h"

// Global Variables

CGCodeInterpreter Interpreter;
CString	GCodeOutput;
int	ErrorLineNo, CurrentLineNo;
CString	ErrorMsg;
int	exitcode;
bool Finished;

void CompleteCallback(int status, int line_no, const char *err)
{
	ErrorLineNo=line_no;
	ErrorMsg=err;
	exitcode=status;
	Finished=true;
}

void StatusCallback(int line_no, const char *msg)
{
	CurrentLineNo=line_no;
	GCodeOutput+=msg;
}


int main(int argc, char* argv[])
{
	int DisplayedLineNo,board=0;
	CString InFile="C:\\KMotionSrc\\GCode Programs\\SimpleCircle.ngc";

	MOTION_PARAMS *p=Interpreter.GetMotionParams();

	p->BreakAngle = 30;
	p->MaxAccelX = 1;
	p->MaxAccelY = 1;
	p->MaxAccelZ = 1;
	p->MaxAccelA = 1;
	p->MaxVelX = 1;
	p->MaxVelY = 1;
	p->MaxVelZ = 1;
	p->MaxVelA = 1;
	p->CountsPerInchX = 100;
	p->CountsPerInchY = 100;
	p->CountsPerInchZ = 100;
	p->CountsPerInchA = 100;
	strcpy(Interpreter.ToolFile,"");
	strcpy(Interpreter.SetupFile,"");

	Finished=false;

	// Execute the GCode!

	Interpreter.Interpret(board,InFile,0,-1,true,StatusCallback,CompleteCallback);

	// Display Current Line Number while executing

	DisplayedLineNo=0;
	while (!Finished)
	{
		if (CurrentLineNo>DisplayedLineNo)
		{
			DisplayedLineNo=CurrentLineNo;
			printf("Current Line = %d\r",CurrentLineNo);
		}
		Sleep(10);
	}

	// Check Interpreter's exit code

	if (exitcode)
	{
		printf("Error in line %d\n",ErrorLineNo);
		printf("%s\n",ErrorMsg.GetBuffer(0));
	}
	else
	{
		printf("%s\n",GCodeOutput.GetBuffer(0));
	}

	getchar();
	return 0;
}

